#include <dos.h>

#define LMB 1
#define RMB 2
#define CMB 4

#define SETUP_DISPLAY                                          \
   {                                                           \
	  cursor_x = EXTENT_X/2 - XD;                              \
	  cursor_y = EXTENT_Y/2 - YD;                              \
	  buttons = 0;                                             \
	}

#define EXTENT_X    634 /* Hightest X-axis cursor position.    */
#define EXTENT_Y    474 /* Hightest Y-axis cursor position.    */
#define XD            4 /* Pixels per X-axis cursor movement.  */
#define YD            3 /* Pixels per Y-axis cursor movement.  */

typedef struct mouse_desc
{
   int x,y;      /* Records current x,y mouse position         */
   int buttons;  /* Records the mouse button status            */
} MOUSE;


int          cursor_x; /* Cursor X-axis position in pixels     */
int          cursor_y; /* Cursor Y-axis position in pixels     */
int          buttons;  /* Current mouse button status.         */
MOUSE        mouse;    /* Mouse descriptor variable            */
union REGS   inregs;   /* Input registers for int86()          */
union REGS   outregs;  /* Output registers for int86()         */

mouse_handler()
{
   SETUP_DISPLAY;
   mouse_setup(EXTENT_X,EXTENT_Y);
   return 0;
}

mousex()
{
   mouse_status(&mouse);
   cursor_x = mouse.x;
   return cursor_x;
}

mousey()
{
   mouse_status(&mouse);
   cursor_y = mouse.y;
   return cursor_y;
}

mouseb()
{
   mouse_status(&mouse);
   buttons = mouse.buttons;
   return buttons;
}

/* This routine call the DOS 33H interrupt to initialize the   */
/* mouse for the current video mode X and Y extents.           */

mouse_setup(max_x,max_y)
   int max_x,max_y;
{

   inregs.x.ax = 0;
   int86(0x33,&inregs,&outregs);

   inregs.x.ax = 7;
   inregs.x.cx = 0;
   inregs.x.dx = max_x;
   int86(0x33,&inregs,&outregs);

   inregs.x.ax = 8;
   inregs.x.cx = 0;
   inregs.x.dx = max_y;
   int86(0x33,&inregs,&outregs);
   return 0;
}

mouse_status(mm)
   MOUSE *mm;
{
   inregs.x.ax = 3;
   int86(0x33,&inregs,&outregs);
   mm->buttons = outregs.x.bx;
   mm->x = outregs.x.cx;
   mm->y = outregs.x.dx;
   return 0;
}